{%- if cookiecutter.use_frontend and cookiecutter.use_jwt %}
import { describe, it, expect, beforeEach } from "vitest";
import { useAuthStore } from "./auth-store";
import type { User } from "@/types";

const createMockUser = (overrides?: Partial<User>): User => ({
  id: "test-id",
  email: "test@example.com",
  is_active: true,
  created_at: new Date().toISOString(),
  ...overrides,
});

describe("Auth Store", () => {
  beforeEach(() => {
    // Reset store before each test
    useAuthStore.setState({
      user: null,
      isAuthenticated: false,
      isLoading: false,
    });
  });

  it("should have initial state", () => {
    const state = useAuthStore.getState();
    expect(state.user).toBeNull();
    expect(state.isAuthenticated).toBe(false);
    expect(state.isLoading).toBe(false);
  });

  it("should set user on setUser", () => {
    const testUser = createMockUser();

    useAuthStore.getState().setUser(testUser);

    const state = useAuthStore.getState();
    expect(state.user).toEqual(testUser);
    expect(state.isAuthenticated).toBe(true);
  });

  it("should clear user on logout", () => {
    // First set a user
    useAuthStore.getState().setUser(createMockUser());

    // Then logout
    useAuthStore.getState().logout();

    const state = useAuthStore.getState();
    expect(state.user).toBeNull();
    expect(state.isAuthenticated).toBe(false);
  });

  it("should set loading state", () => {
    useAuthStore.getState().setLoading(true);
    expect(useAuthStore.getState().isLoading).toBe(true);

    useAuthStore.getState().setLoading(false);
    expect(useAuthStore.getState().isLoading).toBe(false);
  });
});
{%- elif cookiecutter.use_frontend %}
import { describe, it, expect } from "vitest";

describe("Auth Store", () => {
  it.skip("JWT authentication not enabled", () => {
    // Skip auth store tests when JWT is not configured
  });
});
{%- else %}
/* Auth store tests - frontend not configured */
export {};
{%- endif %}
